/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.rcp.databinding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.wb.rcp.databinding.IdentityWrapper;

final class ListenerSupport {
    private final PropertyChangeListener m_listener;
    private final List<String> m_properties;
    private final Set<IdentityWrapper> m_elementsListenedTo = new HashSet<IdentityWrapper>();

    public ListenerSupport(final PropertyChangeListener listener, List<String> properties) {
        this.m_properties = properties;
        this.m_listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (ListenerSupport.this.m_properties.contains(event.getPropertyName())) {
                    listener.propertyChange(event);
                }
            }
        };
    }

    public void hookListener(Object addedElement) {
        if (this.processListener("addPropertyChangeListener", addedElement)) {
            this.m_elementsListenedTo.add(new IdentityWrapper(addedElement));
        }
    }

    public void unhookListener(Object removedElement) {
        if (removedElement.getClass() == IdentityWrapper.class) {
            IdentityWrapper wrapper = (IdentityWrapper)removedElement;
            removedElement = wrapper.unwrap();
        }
        if (this.processListener("removePropertyChangeListener", removedElement)) {
            this.m_elementsListenedTo.remove(new IdentityWrapper(removedElement));
        }
    }

    public void dispose() {
        for (IdentityWrapper wrapper : this.m_elementsListenedTo) {
            if (!this.processListener("removePropertyChangeListener", wrapper.unwrap())) continue;
            this.m_elementsListenedTo.remove(wrapper);
        }
        this.m_elementsListenedTo.clear();
    }

    private boolean processListener(String methodName, Object target) {
        AccessibleObject method = null;
        int parameters = 0;
        try {
            try {
                method = target.getClass().getMethod(methodName, String.class, PropertyChangeListener.class);
                parameters = 2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = target.getClass().getMethod(methodName, PropertyChangeListener.class);
                parameters = 1;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (method != null && parameters != 0) {
            if (!method.isAccessible()) {
                ((Method)method).setAccessible(true);
            }
            try {
                if (parameters == 1) {
                    ((Method)method).invoke(target, this.m_listener);
                } else {
                    for (String propertyName : this.m_properties) {
                        ((Method)method).invoke(target, propertyName, this.m_listener);
                    }
                }
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

